<?php 
$pageTitle = "Sierro Engenharia - Home";
include 'header.php'; 
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Sierro Engenharia'; ?></title>
    <link rel="stylesheet" href="css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Meta Tags Principais -->
    <title>Sierro Engenharia - Spray Dryer, Transporte Pneumático e Engenharia Industrial</title>
    <meta name="description" content="Especialistas em Spray Dryer, Transporte Pneumático de Grãos, Sólidos e Pós. Soluções em Secagem de Café Solúvel, Leite em Pó e Aromas. 60+ anos de experiência em engenharia industrial.">
    
    <!-- Meta Tags para palavras-chave (Keywords) -->
    <meta name="keywords" content="spray dryer, transporte pneumático, transportador pneumático, secagem de café solúvel, secagem de leite em pó, engenharia industrial, transporte pneumático de grãos, transporte pneumático de sólidos, torre de secagem, secagem de aromas">
    
    <!-- Meta Tags Open Graph para Redes Sociais -->
    <meta property="og:title" content="Sierro Engenharia - Especialistas em Spray Dryer e Transporte Pneumático">
    <meta property="og:description" content="Soluções completas em Spray Dryer, Transporte Pneumático e Engenharia Industrial. Expertise em secagem de café solúvel, leite em pó e transporte de grãos.">
    <meta property="og:image" content="https://https://sierroengenharia.com.br/images/og-image.jpg">
    <meta property="og:url" content="https://sierroengenharia.com.br">
    <meta property="og:type" content="website">
    
    <!-- Meta Tags para o Google -->
    <meta name="robots" content="index, follow">
    <meta name="googlebot" content="index, follow">
    <meta name="rating" content="General">
    <meta name="revisit-after" content="7 days">
    <meta name="language" content="pt-BR">
    
    <!-- Meta Tags Específicas do Negócio -->
    <meta name="industry" content="Engenharia Industrial, Equipamentos Industriais">
    <meta name="subject" content="Spray Dryer, Transporte Pneumático, Secagem Industrial">
    <meta name="copyright" content="Sierro Engenharia">
    <meta name="author" content="Sierro Engenharia">
    
    <style>
main {
    display: block;
    width: 100%;
    margin-top: 0;
    padding-top: 0;
}

.about-section {
    padding: 80px 0;
    background: #f8f9fa;
    margin-top: 0;
    position: relative;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 15px;
    width: 100%;
}

.about-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 50px;
    align-items: center;
}

.image-wrapper {
    position: relative;
    width: 100%;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.about-image {
    width: 100%;
    height: auto;
    display: block;
    object-fit: cover;
    transition: transform 0.5s ease;
}

.image-wrapper:hover .about-image {
    transform: scale(1.05);
}

.experience-badge {
    position: absolute;
    bottom: 30px;
    right: -20px;
    background: #00214e;
    color: white;
    padding: 20px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 10px 20px rgba(0,0,0,0.1);
}

.years {
    font-size: 2.5rem;
    font-weight: 700;
    display: block;
    line-height: 1;
}

.text {
    font-size: 0.9rem;
    opacity: 0.9;
}

.section-subtitle {
    color: #e4451d;
    font-size: 1.1rem;
    font-weight: 500;
    margin-bottom: 15px;
    text-transform: uppercase;
    letter-spacing: 2px;
}

.section-title {
    color: #00214e;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 30px;
    position: relative;
    padding-bottom: 15px;
}

.section-title::after {
    content: '';
    position: absolute;
    left: 0;
    bottom: 0;
    width: 50px;
    height: 3px;
    background: #e4451d;
    border-radius: 2px;
}

.main-description {
    font-size: 1.1rem;
    line-height: 1.8;
    color: #333;
    margin-bottom: 25px;
}

.secondary-description {
    color: #555;
    margin-bottom: 30px;
}

.industries-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
    gap: 20px;
    margin-top: 30px;
}

.industry-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 15px;
    background: white;
    border-radius: 10px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.05);
    transition: all 0.3s ease;
}

.industry-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    background: #00214e;
    color: white;
}

.industry-item i {
    font-size: 1.2rem;
    color: #e4451d;
}

.industry-item:hover i {
    color: white;
}

.industry-item span {
    font-size: 0.9rem;
    font-weight: 500;
}

@media (max-width: 992px) {
    .about-grid {
        grid-template-columns: 1fr;
        gap: 40px;
    }

    .about-image-column {
        order: 2;
    }

    .about-content-column {
        order: 1;
    }

    .section-title {
        font-size: 2rem;
    }

    .experience-badge {
        right: 20px;
    }
}

@media (max-width: 768px) {
    .about-section {
        padding: 60px 0;
    }

    .industries-grid {
        grid-template-columns: repeat(auto-fit, minmax(130px, 1fr));
        gap: 15px;
    }

    .industry-item {
        padding: 10px;
    }

    .section-title {
        font-size: 1.8rem;
    }
}
</style>
</head>
<body>
 <!-- ################# Slider Section -->
<!-- Hero Slider Section -->
<section class="hero-slider">
    <div class="slider-container">
        <div class="slider" id="slider">
            <!-- Slide 1 -->
            <div class="slide">
                <a href="servicos.php" class="slide-link">
                    <picture>
                        <!-- Versão mobile da imagem -->
                        <source media="(max-width: 768px)" 
                                srcset="images/slider/slider1_web.png"
                                type="image/webp">
                        <source media="(max-width: 768px)" 
                                srcset="images/slider/slide2.webp">
                        <!-- Versão desktop da imagem -->
                        <source srcset="images/slider/slide2.png" 
                                type="image/webp">
                        <img src="images/slider/slide2.png" 
                             alt="Transportador Helicoidal"
                             loading="lazy"
                             class="slide-image">
                    </picture>
                    <div class="slide-overlay">
                        <div class="slide-content">
                            <div class="slide-content-inner" data-aos="fade-up" data-aos-delay="200">
                                
                                
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <!-- Slide 2 -->
            <div class="slide">
                <a href="equipamentos.php" class="slide-link">
                    <picture>
                        <!-- Versão mobile da imagem -->
                        <source media="(max-width: 768px)" 
                                srcset="images/slider/slide2_web.png"
                                type="image/webp">
                        <source media="(max-width: 768px)" 
                                srcset="images/slider/slider1.png">
                        <!-- Versão desktop da imagem -->
                        <source srcset="images/slider/slider1.png" 
                                type="image/webp">
                        <img src="images/slider/slider1.png" 
                             alt="Roscas Transportadoras"
                             loading="lazy"
                             class="slide-image">
                    </picture>
                    <div class="slide-overlay">
                        <div class="slide-content">
                            <div class="slide-content-inner" data-aos="fade-up" data-aos-delay="200">
                                
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>

        <!-- Controles do Slider -->
        <div class="slider-controls">
            <!-- Setas de Navegação -->
            <button class="slider-arrow prev" id="prevBtn" aria-label="Slide anterior">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="15 18 9 12 15 6"></polyline>
                </svg>
            </button>
            <button class="slider-arrow next" id="nextBtn" aria-label="Próximo slide">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="9 18 15 12 9 6"></polyline>
                </svg>
            </button>

            <!-- Dots de Navegação -->
            <div class="slider-nav" id="sliderNav">
                <!-- Dots serão inseridos via JavaScript -->
            </div>
        </div>

        <!-- Progress Bar -->
        <div class="slider-progress">
            <div class="progress-bar"></div>
        </div>
    </div>
</section>

<!-- Início do Main Content -->

<main>
    <section class="about-section">
        <div class="container">
            <div class="about-grid">
                <!-- Coluna da Imagem -->
                <div class="about-image-column" data-aos="fade-right">
                    <div class="image-wrapper">
                        <img src="images/cone.jpg" alt="Sierro Engenharia" class="about-image">
                        <div class="experience-badge">
                            <span class="years">60+</span>
                            <span class="text">Anos de<br>Experiência</span>
                        </div>
                    </div>
                </div>

                <!-- Coluna do Texto -->
                <div class="about-content-column" data-aos="fade-left">
                    <div class="section-subtitle">Sobre Nós</div>
                    <h2 class="section-title">Conheça a Sierro</h2>
                    
                    <div class="about-text">
                        <p class="main-description">
                            A Sierro Engenharia traz experiência e tecnologia desde 1962, quando chegou ao Brasil por meio da Nestlé, com o propósito de oferecer projetos e soluções tecnológicas de equipamentos agroindustriais para Leite em Pó, Baby Food e Café Solúvel.
                        </p>

                        <p class="secondary-description">
                            Ao longo dos anos, outros setores além do Sucroalcooleiro têm se beneficiado dessa 
                            tecnologia e equipamentos:
                        </p>

                        <div class="industries-grid">
                            <div class="industry-item">
                                <i class="fas fa-coffee"></i>
                                <span>Plantas de Café Solúvel</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-flask"></i>
                                <span>Aromas</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-apple-alt"></i>
                                <span>Suco de Frutas</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-seedling"></i>
                                <span>Beneficiamento de Grãos</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-cookie"></i>
                                <span>Carboidratos em Geral</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-bone"></i>
                                <span>Plantas de Produção de Ração Animal</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-flask-vial"></i>
                                <span>Laboratórios de Pesquisa e Desenvolvimento</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-cube"></i>
                                <span>Plantas de Produção de Gelatina</span>
                            </div>
                            <div class="industry-item">
                                <i class="fas fa-industry"></i>
                                <span>Sucroalcooleiro</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<!-- Separador Moderno -->
<div class="section-divider">
    <div class="divider-content">
        <div class="divider-line"></div>
        <div class="divider-icon">
            <i class="fas fa-cog"></i>
        </div>
        <div class="divider-line"></div>
    </div>
    <div class="divider-pattern">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#f8f9fa" fill-opacity="1" d="M0,32L48,37.3C96,43,192,53,288,58.7C384,64,480,64,576,58.7C672,53,768,43,864,48C960,53,1056,75,1152,80C1248,85,1344,75,1392,69.3L1440,64L1440,120L1392,120C1344,120,1248,120,1152,120C1056,120,960,120,864,120C768,120,672,120,576,120C480,120,384,120,288,120C192,120,96,120,48,120L0,120Z"></path>
        </svg>
    </div>
</div>

<!-- Seção de Serviços -->
<section class="services-section" id="servicos">
    <div class="container">
        <div class="services-header" data-aos="fade-up">
            <h2 class="section-title">Nossos Serviços</h2>
            <div class="section-description">
                Soluções completas e inovadoras para sua indústria
            </div>
        </div>

        <div class="services-grid">
            <!-- Card 1 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="100">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-spray-can"></i>
                        </div>
                        <h3>Projetos de Spray Dryer</h3>
                        <p>Tecnologia avançada em sistemas de secagem por atomização</p>
                    </div>
                    <div class="service-back">
                        <h4>Spray Dryer</h4>
                        <ul>
                            <li>Desenvolvimento de projetos customizados</li>
                            <li>Alta eficiência energética</li>
                            <li>Tecnologia de ponta</li>
                        </ul>
                        <a href="spray-dryer.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>

            <!-- Card 2 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="200">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-sync-alt"></i>
                        </div>
                        <h3>Conversão de Spray Dryer</h3>
                        <p>Modernização de sistemas de disco para maior eficiência</p>
                    </div>
                    <div class="service-back">
                        <h4>Conversão de Sistemas</h4>
                        <ul>
                            <li>Atualização tecnológica</li>
                            <li>Aumento de produtividade</li>
                            <li>Redução de custos operacionais</li>
                        </ul>
                        <a href="conversao-spray.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>

            <!-- Card 3 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="300">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-coffee"></i>
                        </div>
                        <h3>Café Solúvel e Leite em Pó</h3>
                        <p>Soluções especializadas para a indústria alimentícia</p>
                    </div>
                    <div class="service-back">
                        <h4>Indústria Alimentícia</h4>
                        <ul>
                            <li>Processos otimizados</li>
                            <li>Qualidade superior</li>
                            <li>Segurança alimentar</li>
                        </ul>
                        <a href="projetos-cafe-soluvel.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>

             <!-- Card 4 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="400">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-flask"></i>
                        </div>
                        <h3>Secagem de Levedura</h3>
                        <p>Tecnologia especializada para processamento biotecnológico</p>
                    </div>
                    <div class="service-back">
                        <h4>Secagem de Levedura</h4>
                        <ul>
                            <li>Alta eficiência no processo</li>
                            <li>Controle preciso de temperatura</li>
                            <li>Preservação das propriedades</li>
                        </ul>
                        <a href="secagem-levedura.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>

            <!-- Card 5 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="500">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-wind"></i>
                        </div>
                        <h3>Transporte Pneumático</h3>
                        <p>Soluções eficientes para movimentação de materiais</p>
                    </div>
                    <div class="service-back">
                        <h4>Transporte Pneumático</h4>
                        <ul>
                            <li>Sistema automatizado</li>
                            <li>Alta capacidade de transporte</li>
                            <li>Baixa manutenção</li>
                        </ul>
                        <a href="transporte_pneumatico.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>

            <!-- Card 6 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="600">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-industry"></i>
                        </div>
                        <h3>Equipamentos Industriais</h3>
                        <p>Soluções completas em equipamentos para sua indústria</p>
                    </div>
                    <div class="service-back">
                        <h4>Equipamentos</h4>
                        <ul>
                            <li>Projetos personalizados</li>
                            <li>Alta durabilidade</li>
                            <li>Tecnologia avançada</li>
                        </ul>
                        <a href="equipamentos.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>

            <!-- Card 7 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="700">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-tasks"></i>
                        </div>
                        <h3>Consultoria e Gerenciamento</h3>
                        <p>Consultoria, Projetos, Gerenciamento e Comissionamento</p>
                    </div>
                    <div class="service-back">
                        <h4>Gestão de Projetos</h4>
                        <ul>
                            <li>Análise técnica especializada</li>
                            <li>Gerenciamento completo</li>
                            <li>Suporte contínuo</li>
                        </ul>
                        <a href="consultoria.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>

            <!-- Card 8 -->
            <div class="service-card" data-aos="fade-up" data-aos-delay="800">
                <div class="service-card-inner">
                    <div class="service-front">
                        <div class="service-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                        <h3>Excelência em Projetos</h3>
                        <p>Análise e Projetos para Melhoria Contínua</p>
                    </div>
                    <div class="service-back">
                        <h4>Melhoria Contínua</h4>
                        <ul>
                            <li>Otimização de processos</li>
                            <li>Análise de eficiência</li>
                            <li>Soluções inovadoras</li>
                        </ul>
                        <a href="excelencia.php" class="service-btn">Saiba Mais</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Seção Clientes e Atuação -->

<section class="clients-section">
    <div class="container">
        <div class="section-header" data-aos="fade-up">
            <span class="section-subtitle">Presença Global</span>
            <h2 class="section-title">Nossos Clientes e Atuação</h2>
            <p class="section-description">Conheça nossa presença mundial e os parceiros que confiam em nosso trabalho</p>
        </div>

        <div class="clients-showcase">
            <!-- Mapa Mundial com Empresas -->
            <div class="showcase-item" data-aos="fade-up">
                <div class="image-container">
                    <img src="images/mapa.png" alt="Mapa de Atuação Global" class="showcase-image">
                    <div class="image-overlay">
                        <h3>Presença Global</h3>
                        <p>Nossa atuação em diferentes continentes</p>
                    </div>
                </div>
            </div>

            <!-- Lista de Empresas -->
            <div class="showcase-item" data-aos="fade-up" data-aos-delay="200">
                <div class="image-container">
                    <img src="images/parceiros.png" alt="Nossos Clientes" class="showcase-image">
                    <div class="image-overlay">
                        <h3>Clientes Parceiros</h3>
                        <p>Empresas que confiam em nosso trabalho</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--###################### WhatsApp Float Button ################-->
<!-- WhatsApp Float Button -->
<div class="whatsapp-float">
    <div class="whatsapp-tooltip">Precisa de ajuda? Fale conosco!</div>
    <a href="https://wa.me/5511983838641" class="whatsapp-button" target="_blank" rel="noopener noreferrer">
        <!-- WhatsApp Icon (menor e otimizado) -->
        <svg class="whatsapp-icon" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path fill="currentColor" d="M12 2C6.477 2 2 6.477 2 12c0 1.89.525 3.66 1.438 5.168L2 22l4.916-1.496A9.936 9.936 0 0012 22c5.523 0 10-4.477 10-10S17.523 2 12 2zm0 18c-1.476 0-2.914-.42-4.148-1.207l-.297-.18-3.073.932.947-3.045-.197-.314A7.946 7.946 0 014 12c0-4.418 3.582-8 8-8s8 3.582 8 8-3.582 8-8 8zm4.727-5.914c-.252-.126-1.492-.736-1.723-.82-.23-.084-.398-.126-.566.126-.168.252-.65.82-.797.987-.146.168-.293.19-.545.063-1.482-.74-2.455-1.32-3.43-2.993-.26-.446.26-.413.744-1.376.083-.168.042-.314-.02-.44-.063-.127-.566-1.363-.775-1.867-.204-.484-.41-.42-.566-.428-.146-.008-.314-.01-.482-.01-.168 0-.44.063-.67.314-.23.252-.88.86-.88 2.094 0 1.236.9 2.43 1.023 2.598.124.167 1.742 2.665 4.22 3.74.59.254 1.05.407 1.408.52.592.19 1.13.162 1.558.098.475-.07 1.463-.598 1.67-1.177.207-.578.207-1.073.145-1.177-.063-.103-.23-.165-.482-.29z"/>
        </svg>
        <span class="whatsapp-text">Fale conosco</span>
    </a>
</div>
<!-- Script para animação suave -->
<!-- Script melhorado -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const whatsappFloat = document.querySelector('.whatsapp-float');
    
    // Aparece suavemente após 1.5 segundos
    setTimeout(() => {
        whatsappFloat.classList.add('visible');
    }, 1500);

    // Controle de visibilidade na rolagem
    let scrollTimer;
    window.addEventListener('scroll', () => {
        clearTimeout(scrollTimer);
        
        if (!whatsappFloat.classList.contains('visible')) {
            whatsappFloat.classList.add('visible');
        }
        
        scrollTimer = setTimeout(() => {
            if (window.pageYOffset > 100) {
                whatsappFloat.style.transform = 'translateY(0)';
            }
        }, 150);
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    AOS.init({
        duration: 800,
        once: true,
        offset: 100,
        delay: 200
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Pega todos os links do menu
    const menuLinks = document.querySelectorAll('.nav-link');
    
    menuLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            // Verifica se o link tem um hash (#)
            if (this.hash !== "") {
                // Verifica se estamos na página index
                if (window.location.pathname.includes('index.php') || 
                    window.location.pathname === '/') {
                    e.preventDefault();
                    
                    const hash = this.hash;
                    const target = document.querySelector(hash);
                    
                    // Rola suavemente até a seção
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                    
                    // Atualiza a URL
                    history.pushState(null, null, hash);
                }
            }
        });
    });
    
    // Verifica se há um hash na URL ao carregar a página
    if (window.location.hash && 
        (window.location.pathname.includes('index.php') || 
         window.location.pathname === '/')) {
        const target = document.querySelector(window.location.hash);
        if (target) {
            setTimeout(() => {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }, 100);
        }
    }
});
</script>

 <!-- Meta Tags Schema.org para Rich Snippets -->
    <script type="application/ld+json">
    {
        "@context": "http://schema.org",
        "@type": "Organization",
        "name": "Sierro Engenharia",
        "description": "Especialistas em Spray Dryer e Transporte Pneumático Industrial",
        "url": "https://sierroengenharia.com.br/novo/",
        "logo": "https://sierroengenharia.com.br/images/logo.png",
        "contactPoint": {
            "@type": "ContactPoint",
            "telephone": "seu-telefone",
            "contactType": "customer service"
        },
        "sameAs": [
            "https://facebook.com/sierroengenharia",
            "https://linkedin.com/company/sierroengenharia"
        ]
    }
    </script>


</body>
</html>

<?php include 'footer.php'; ?>