<?php 
$pageTitle = 'Execução de Projetos - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Execução de Projetos</h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">Gerenciamento integral e suporte técnico especializado</p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Suporte Integral</div>
                        <p>
                            A Sierro Engenharia oferece um serviço completo e especializado na execução de projetos, garantindo não apenas a entrega dos equipamentos com qualidade, mas também o gerenciamento operacional com suporte integral durante todas as fases do processo.
                        </p>
                    </div>

                    <!-- Serviços Grid -->
                    <div class="services-wrapper">
                        <h3 class="services-title">Nossos serviços incluem:</h3>
                        <div class="services-grid">
                            <!-- Serviço 1 -->
                            <div class="service-card" data-aos="fade-up">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-lightbulb"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Consultoria de apoio tecnológico</h4>
                                    <p>Oferecemos orientação técnica especializada para otimização de processos industriais e implementação de novas tecnologias.</p>
                                </div>
                            </div>

                            <!-- Serviço 2 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="100">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-tasks"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Projetos com suporte completo</h4>
                                    <p>Desenvolvimento de projetos desde a concepção até a implementação, com acompanhamento técnico especializado em todas as etapas.</p>
                                </div>
                            </div>

                            <!-- Serviço 3 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="200">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-drafting-compass"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Desenhos mecânicos construtivos e isométricos</h4>
                                    <p>Elaboração de documentação técnica detalhada para fabricação, montagem e manutenção de equipamentos e sistemas.</p>
                                </div>
                            </div>

                            <!-- Serviço 4 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="300">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-file-signature"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>ART's</h4>
                                    <p>Emissão de Anotações de Responsabilidade Técnica para garantir conformidade legal e segurança em todos os projetos executados.</p>
                                </div>
                            </div>

                            <!-- Serviço 5 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="400">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-clipboard-check"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Acompanhamento na execução</h4>
                                    <p>Supervisão técnica durante todo o processo de implementação para garantir a correta execução do projeto conforme especificações.</p>
                                </div>
                            </div>

                            <!-- Serviço 6 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="500">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-search"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Checagem nas instalações</h4>
                                    <p>Inspeção técnica minuciosa para assegurar que todas as instalações atendam aos padrões de qualidade e segurança exigidos.</p>
                                </div>
                            </div>

                            <!-- Serviço 7 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="600">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-user-cog"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Treinamento dos Colaboradores</h4>
                                    <p>Capacitação técnica das equipes para operação eficiente e segura dos equipamentos e sistemas instalados.</p>
                                </div>
                            </div>

                            <!-- Serviço 8 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="700">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-play-circle"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Start-up dos Equipamentos</h4>
                                    <p>Procedimentos de acionamento e ajustes iniciais para garantir o correto funcionamento dos sistemas instalados.</p>
                                </div>
                            </div>

                            <!-- Serviço 9 -->
                            <div class="service-card" data-aos="fade-up" data-aos-delay="800">
                                <div class="service-icon-wrap">
                                    <div class="service-icon">
                                        <i class="fas fa-handshake"></i>
                                    </div>
                                </div>
                                <div class="service-content">
                                    <h4>Comissionamento com nossos parceiros</h4>
                                    <p>Validação final dos sistemas em parceria com especialistas para assegurar a integração e funcionamento ideal de todos os componentes.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Processo de Trabalho -->
                    <div class="workflow-section">
                        <h3 class="workflow-title">Processo de Execução</h3>
                        <div class="workflow-diagram">
                            <div class="workflow-step" data-aos="fade-right" data-aos-delay="100">
                                <div class="workflow-number">1</div>
                                <div class="workflow-label">Planejamento</div>
                            </div>
                            <div class="workflow-arrow">
                                <i class="fas fa-long-arrow-alt-right"></i>
                            </div>
                            <div class="workflow-step" data-aos="fade-right" data-aos-delay="200">
                                <div class="workflow-number">2</div>
                                <div class="workflow-label">Projeto</div>
                            </div>
                            <div class="workflow-arrow">
                                <i class="fas fa-long-arrow-alt-right"></i>
                            </div>
                            <div class="workflow-step" data-aos="fade-right" data-aos-delay="300">
                                <div class="workflow-number">3</div>
                                <div class="workflow-label">Execução</div>
                            </div>
                            <div class="workflow-arrow">
                                <i class="fas fa-long-arrow-alt-right"></i>
                            </div>
                            <div class="workflow-step" data-aos="fade-right" data-aos-delay="400">
                                <div class="workflow-number">4</div>
                                <div class="workflow-label">Comissionamento</div>
                            </div>
                            <div class="workflow-arrow">
                                <i class="fas fa-long-arrow-alt-right"></i>
                            </div>
                            <div class="workflow-step" data-aos="fade-right" data-aos-delay="500">
                                <div class="workflow-number">5</div>
                                <div class="workflow-label">Suporte</div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="cta-section">
                        <div class="cta-content">
                            <h2>Precisa de suporte especializado?</h2>
                            <p>Entre em contato para conhecer nossas soluções completas em execução de projetos</p>
                            <a href="contato.php" class="cta-button">
                                <span>Solicitar Orçamento</span>
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/equipamentos1.png" alt="Execução de Projetos Industriais - Sierro Engenharia">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-check-double"></i>
                                    <span>Qualidade Garantida</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-calendar-check"></i>
                                    <span>Cumprimento de Prazos</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-shield-alt"></i>
                                    <span>Segurança Total</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Benefícios -->
                    <div class="benefits-box">
                        <h3 class="benefits-title">Benefícios do Nosso Serviço</h3>
                        <ul class="benefits-list">
                            <li class="benefit-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Redução de riscos operacionais</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Otimização de recursos</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Maximização da eficiência produtiva</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Conformidade com normas técnicas</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Acompanhamento técnico especializado</span>
                            </li>
                            <li class="benefit-item">
                                <i class="fas fa-check-circle"></i>
                                <span>Garantia de qualidade em todas as etapas</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Depoimento -->
                    <div class="testimonial-card">
                        <div class="testimonial-icon">
                            <i class="fas fa-quote-left"></i>
                        </div>
                        <blockquote class="testimonial-text">
                            A execução de projetos da Sierro superou nossas expectativas. O suporte técnico completo e a capacidade de solucionar desafios durante a implementação foram diferenciais importantes para o sucesso do nosso projeto.
                        </blockquote>
                        <div class="testimonial-author">
                            <div class="author-name">Cliente Satisfeito</div>
                            <div class="author-title">Indústria Alimentícia</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Layout Principal */
.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Texto e Conteúdo */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 40px;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

.text-block p {
    font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
    margin: 0;
}

/* Serviços Grid */
.services-wrapper {
    margin: 50px 0;
}

.services-title {
    color: #00214e;
    font-weight: 600;
    margin-bottom: 30px;
}

.services-grid {
    display: flex;
    flex-direction: column;
    gap: 25px;
}

.service-card {
    display: flex;
    background: #f8f9fa;
    border-radius: 15px;
    overflow: hidden;
    transition: all 0.3s ease;
    position: relative;
}

.service-card:hover {
    transform: translateY(-5px);
    background: #fff2f0;
}

.service-icon-wrap {
    width: 80px;
    min-width: 80px;
    padding: 20px 0;
    background: rgba(0,33,78,0.05);
    display: flex;
    justify-content: center;
    align-items: flex-start;
}

.service-icon {
    width: 50px;
    height: 50px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.service-icon i {
    font-size: 20px;
    color: #e4451d;
}

.service-content {
    padding: 20px;
}

.service-content h4 {
    margin: 0 0 10px;
    color: #00214e;
    font-size: 1.2rem;
    font-weight: 600;
}

.service-content p {
    margin: 0;
    font-size: 1rem;
    color: #666;
    line-height: 1.6;
}

/* Workflow Section */
.workflow-section {
    margin: 60px 0;
    padding: 30px;
    background: #f8f9fa;
    border-radius: 15px;
}

.workflow-title {
    text-align: center;
    color: #00214e;
    font-weight: 600;
    margin-bottom: 30px;
}

.workflow-diagram {
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: wrap;
}

.workflow-step {
    text-align: center;
}

.workflow-number {
    width: 50px;
    height: 50px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 10px;
    font-size: 1.2rem;
    font-weight: 700;
    color: #e4451d;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}

.workflow-label {
    font-size: 0.9rem;
    color: #00214e;
    font-weight: 500;
}

.workflow-arrow {
    color: #ccc;
    font-size: 20px;
    padding: 0 5px;
}

/* Imagem e Overlay */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.image-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
    padding: 30px;
}

.specs-list {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.spec-item {
    color: white;
    text-align: center;
}

.spec-item i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #e4451d;
}

/* Benefícios */
.benefits-box {
    background: white;
    border-radius: 15px;
    padding: 30px;
    margin-top: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.benefits-title {
    color: #00214e;
    font-weight: 600;
    text-align: center;
    margin-bottom: 20px;
}

.benefits-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.benefit-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 12px 0;
    border-bottom: 1px solid rgba(0,0,0,0.05);
}

.benefit-item:last-child {
    border-bottom: none;
}

.benefit-item i {
    color: #e4451d;
}

.benefit-item span {
    font-size: 1rem;
    color: #444;
}

/* Depoimento */
.testimonial-card {
    background: #00214e;
    color: white;
    border-radius: 15px;
    padding: 30px;
    margin-top: 30px;
    position: relative;
    overflow: hidden;
}

.testimonial-icon {
    position: absolute;
    top: 20px;
    left: 20px;
    opacity: 0.1;
    font-size: 4rem;
    color: #e4451d;
}

.testimonial-text {
    font-style: italic;
    font-size: 1.1rem;
    line-height: 1.7;
    margin: 0 0 20px;
    position: relative;
    z-index: 2;
}

.testimonial-author {
    display: flex;
    flex-direction: column;
}

.author-name {
    font-weight: 700;
    font-size: 1.1rem;
}

.author-title {
    font-size: 0.9rem;
    opacity: 0.7;
}

/* CTA Section */
.cta-section {
    text-align: center;
    padding: 60px;
    background: linear-gradient(45deg, #00214e, #003175);
    border-radius: 20px;
    color: white;
    margin-top: 60px;
}

.cta-content h2 {
    font-size: 2.5rem;
    margin-bottom: 20px;
}

.cta-content p {
    font-size: 1.2rem;
    margin-bottom: 30px;
    opacity: 0.9;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: white;
    color: #00214e;
    transform: translateY(-2px);
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }

    .workflow-diagram {
        gap: 20px;
        justify-content: center;
    }

    .workflow-arrow {
        display: none;
    }

    .workflow-step {
        margin: 10px;
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .cta-section {
        padding: 40px 20px;
    }

    .cta-content h2 {
        font-size: 2rem;
    }

    .specs-list {
        grid-template-columns: 1fr;
        gap: 15px;
    }
}
</style>

<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>