<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Blog Sierro Engenharia - Conhecimento Técnico Industrial</title>
    <meta name="description" content="Blog da Sierro Engenharia com artigos técnicos sobre Spray Dryer, Transporte Pneumático e Projetos Industriais. Conheça nossas soluções de engenharia.">
    <meta name="keywords" content="sierro engenharia, spray dryer, transporte pneumático, projeto industrial, engenharia de processos">
    <meta name="author" content="Sierro Engenharia">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://blog.sierroengenharia.com.br/">
    <meta property="og:title" content="Blog Sierro Engenharia - Conhecimento Técnico Industrial">
    <meta property="og:description" content="Blog da Sierro Engenharia com artigos técnicos sobre Spray Dryer, Transporte Pneumático e Projetos Industriais.">
    <meta property="og:image" content="https://sierroengenharia.com.br/images/og-image-blog.png">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="https://blog.sierroengenharia.com.br/">
    <meta property="twitter:title" content="Blog Sierro Engenharia - Conhecimento Técnico Industrial">
    <meta property="twitter:description" content="Blog da Sierro Engenharia com artigos técnicos sobre Spray Dryer, Transporte Pneumático e Projetos Industriais.">
    <meta property="twitter:image" content="https://sierroengenharia.com.br/images/og-image-blog.png">
    
    
    
    <!-- CSS Styling -->
    <style>
        /* Variáveis de cores corporativas */
        :root {
            --primary: #00214e; /* Azul Sierro */
            --secondary: #e4451d; /* Vermelho Sierro */
            --light: #f9f9f9;
            --dark: #333;
            --gray: #6c757d;
            --lightgray: #e9ecef;
            --white: #ffffff;
            --font-primary: 'Poppins', sans-serif;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: var(--font-primary);
            line-height: 1.7;
            color: var(--dark);
            background-color: var(--light);
        }
        
        /* Blog container */
        .blog-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* Blog Header */
        .blog-header {
            background-color: var(--primary);
            padding: 30px 0;
            text-align: center;
            border-radius: 8px;
            margin-bottom: 30px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .blog-header img {
            height: 70px;
            margin-bottom: 15px;
            filter: drop-shadow(0 0 8px rgba(255,255,255,0.6));
        }

        .blog-header h1 {
            font-size: 18px;
            color: var(--white);
            text-transform: uppercase;
            font-weight: 700;
            margin-bottom: 0;
            letter-spacing: 1px;
        }
        
        .blog-nav {
            background-color: var(--primary);
            padding: 15px 0;
            margin-bottom: 40px;
        }
        
        .blog-nav ul {
            display: flex;
            justify-content: center;
            list-style: none;
            flex-wrap: wrap;
        }
        
        .blog-nav li {
            margin: 0 15px;
        }
        
        .blog-nav a {
            color: var(--white);
            text-decoration: none;
            font-size: 1rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .blog-nav a:hover {
            color: var(--secondary);
        }
        
        /* Hero Section */
        .blog-hero {
            position: relative;
            height: 500px;
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 60px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .blog-hero-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .blog-hero-content {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 40px;
            background: linear-gradient(to top, rgba(0,0,0,0.8), rgba(0,0,0,0));
            color: var(--white);
        }
        
        .blog-hero-content h2 {
            font-size: 2.5rem;
            margin-bottom: 15px;
            color: var(--white);
        }
        
        .blog-hero-content p {
            font-size: 1.1rem;
            margin-bottom: 25px;
            max-width: 70%;
        }
        
        .blog-hero-btn {
            display: inline-block;
            background: var(--secondary);
            color: var(--white);
            padding: 12px 25px;
            border-radius: 30px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .blog-hero-btn:hover {
            background: var(--white);
            color: var(--primary);
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        
        /* Categories Section */
        .blog-categories {
            margin-bottom: 60px;
        }
        
        .blog-section-title {
            font-size: 2rem;
            color: var(--primary);
            margin-bottom: 30px;
            text-align: center;
            position: relative;
            padding-bottom: 15px;
        }
        
        .blog-section-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 3px;
            background: var(--secondary);
        }
        
        .categories-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 30px;
        }
        
        .category-card {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s ease;
            background: var(--white);
        }
        
        .category-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        
        .category-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
        
        .category-content {
            padding: 25px;
        }
        
        .category-content h3 {
            color: var(--primary);
            font-size: 1.5rem;
            margin-bottom: 15px;
        }
        
        .category-content p {
            color: var(--gray);
            margin-bottom: 20px;
        }
        
        .category-link {
            display: inline-block;
            color: var(--secondary);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .category-link:hover {
            color: var(--primary);
            text-decoration: underline;
        }
        
        /* Latest Articles */
        .blog-latest {
            margin-bottom: 60px;
        }
        
        .latest-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 30px;
        }
        
        .article-card {
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
            background: var(--white);
            display: flex;
            flex-direction: column;
        }
        
        .article-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        
        .article-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
        
        .article-content {
            padding: 25px;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }
        
        .article-meta {
            display: flex;
            align-items: center;
            color: var(--gray);
            font-size: 0.9rem;
            margin-bottom: 15px;
        }
        
        .article-meta span {
            margin-right: 20px;
            display: flex;
            align-items: center;
        }
        
        .article-meta i {
            margin-right: 5px;
        }
        
        .article-content h3 {
            color: var(--primary);
            font-size: 1.4rem;
            margin-bottom: 15px;
            line-height: 1.4;
        }
        
        .article-content p {
            color: var(--gray);
            margin-bottom: 20px;
            flex-grow: 1;
        }
        
        .article-link {
            align-self: flex-start;
            display: inline-block;
            color: var(--white);
            background: var(--primary);
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .article-link:hover {
            background: var(--secondary);
            transform: translateY(-3px);
        }
        
        /* Newsletter Section */
        .blog-newsletter {
            padding: 60px 40px;
            background: linear-gradient(to right, var(--primary), #003580);
            color: var(--white);
            border-radius: 10px;
            margin-bottom: 60px;
            text-align: center;
        }
        
        .blog-newsletter h2 {
            font-size: 2rem;
            margin-bottom: 20px;
        }
        
        .blog-newsletter p {
            font-size: 1.1rem;
            margin-bottom: 30px;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
        }
        
        .newsletter-form {
            display: flex;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .newsletter-input {
            flex-grow: 1;
            padding: 15px;
            border: none;
            border-radius: 5px 0 0 5px;
            font-family: inherit;
            font-size: 1rem;
        }
        
        .newsletter-btn {
            background: var(--secondary);
            color: var(--white);
            border: none;
            padding: 0 30px;
            border-radius: 0 5px 5px 0;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .newsletter-btn:hover {
            background: #c83814;
        }
        
        /* About Section */
        .blog-about {
            display: flex;
            align-items: center;
            background: var(--white);
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            margin-bottom: 60px;
        }
        
        .about-image {
            flex: 0 0 40%;
            margin-right: 40px;
        }
        
        .about-image img {
            width: 100%;
            border-radius: 10px;
        }
        
        .about-content {
            flex: 1;
        }
        
        .about-content h2 {
            color: var(--primary);
            font-size: 2rem;
            margin-bottom: 20px;
        }
        
        .about-content p {
            margin-bottom: 20px;
            color: var(--gray);
        }
        
        .about-link {
            display: inline-block;
            color: var(--secondary);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .about-link:hover {
            color: var(--primary);
            text-decoration: underline;
        }
        
        /* Footer */
        .blog-footer {
            background: var(--primary);
            color: var(--white);
            padding: 50px 0 20px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 40px;
            margin-bottom: 30px;
        }
        
        .footer-column h4 {
            color: var(--white);
            font-size: 1.2rem;
            margin-bottom: 20px;
        }
        
        .footer-about p {
            margin-bottom: 20px;
            font-size: 0.9rem;
            line-height: 1.6;
        }
        
        .footer-links ul {
            list-style: none;
        }
        
        .footer-links li {
            margin-bottom: 10px;
        }
        
        .footer-links a {
            color: var(--lightgray);
            text-decoration: none;
            transition: color 0.3s ease;
            font-size: 0.9rem;
        }
        
        .footer-links a:hover {
            color: var(--secondary);
        }
        
        .footer-contact p {
            margin-bottom: 15px;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
        }
        
        .footer-contact i {
            margin-right: 10px;
            color: var(--secondary);
        }
        
        .social-icons {
            display: flex;
            gap: 15px;
            margin-top: 20px;
        }
        
        .social-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255,255,255,0.1);
            color: var(--white);
            border-radius: 50%;
            transition: all 0.3s ease;
            text-decoration: none;
        }
        
        .social-icon:hover {
            background: var(--secondary);
            transform: translateY(-3px);
        }
        
        .footer-newsletter p {
            margin-bottom: 20px;
            font-size: 0.9rem;
        }
        
        .newsletter-form {
            display: flex;
        }
        
        .newsletter-input {
            flex: 1;
            padding: 12px;
            border: none;
            border-radius: 5px 0 0 5px;
            font-family: inherit;
        }
        
        .newsletter-btn {
            background: var(--secondary);
            color: var(--white);
            border: none;
            padding: 0 15px;
            border-radius: 0 5px 5px 0;
            cursor: pointer;
        }
        
        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid rgba(255,255,255,0.1);
            font-size: 0.9rem;
            color: var(--lightgray);
        }
        
        /* Responsive Design */
        @media (max-width: 992px) {
            .blog-hero {
                height: 400px;
            }
            
            .blog-hero-content h2 {
                font-size: 2rem;
            }
            
            .blog-hero-content p {
                max-width: 100%;
            }
            
            .blog-about {
                flex-direction: column;
            }
            
            .about-image {
                margin-right: 0;
                margin-bottom: 30px;
                flex: 0 0 100%;
            }
        }
        
        @media (max-width: 768px) {
            .blog-nav ul {
                flex-direction: column;
                text-align: center;
            }
            
            .blog-nav li {
                margin: 5px 0;
            }
            
            .blog-hero {
                height: 350px;
            }
            
            .blog-hero-content h2 {
                font-size: 1.5rem;
            }
            
            .blog-hero-content p {
                font-size: 1rem;
            }
            
            .blog-section-title {
                font-size: 1.5rem;
            }
            
            .latest-grid {
                grid-template-columns: 1fr;
            }
            
            .categories-grid {
                grid-template-columns: 1fr;
            }
            
            .newsletter-form {
                flex-direction: column;
            }
            
            .newsletter-input {
                border-radius: 5px;
                margin-bottom: 10px;
            }
            
            .newsletter-btn {
                border-radius: 5px;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="blog-header">
        <img src="https://sierroengenharia.com.br/images/logo.png" alt="Sierro Engenharia Logo">
        <h1>Blog Sierro Engenharia - Conhecimento Técnico Industrial</h1>
    </header>
    
    <!-- Navigation -->
    <nav class="blog-nav">
        <div class="blog-container">
            <ul>
                <li><a href="index.php">Início</a></li>
                <li><a href="spray-dryer.php">Spray Dryer</a></li>
                <li><a href="categoria-transporte-pneumatico.php">Transporte Pneumático</a></li>
                <li><a href="categoria-projeto-industrial.php">Projeto Industrial</a></li>
                <li><a href="https://sierroengenharia.com.br/contato.php">Contato</a></li>
                <li><a href="https://sierroengenharia.com.br">Site Sierro</a></li>
            </ul>
        </div>
    </nav>
    
    <!-- Main Content -->
    <main class="blog-container">
        <!-- Hero Section -->
        <section class="blog-hero">
            <img src="https://sierroengenharia.com.br/images/spray-dryer-blog.png" alt="Tecnologia Industrial Avançada" class="blog-hero-image">
            <div class="blog-hero-content">
                <h2>Spray Dryer na Indústria Moderna: Tecnologia, Aplicações e Inovações</h2>
                <p>Descubra como o processo de secagem por atomização revoluciona a produção industrial, garantindo eficiência, qualidade e padronização em diversos setores da indústria.</p>
                <a href="spray-dryer.php" class="blog-hero-btn">Leia Nosso Artigo em Destaque</a>
            </div>
        </section>
        
        <!-- Categories Section -->
        <section class="blog-categories">
            <h2 class="blog-section-title">Categorias Principais</h2>
            <div class="categories-grid">
                <div class="category-card">
                    <img src="https://sierroengenharia.com.br/images/blog/spray-dryer-category.jpg" alt="Spray Dryer" class="category-image">
                    <div class="category-content">
                        <h3>Spray Dryer</h3>
                        <p>Tecnologia de secagem por atomização, aplicações, inovações e soluções para diversos setores industriais.</p>
                        <a href="spray-dryer.php" class="category-link">Explorar Artigos <i class="fas fa-arrow-right"></i></a>
                    </div>
                </div>
                
                <div class="category-card">
                    <img src="https://sierroengenharia.com.br/images/blog/transporte-pneumatico-category.jpg" alt="Transporte Pneumático" class="category-image">
                    <div class="category-content">
                        <h3>Transporte Pneumático</h3>
                        <p>Sistemas eficientes para movimentação de materiais sólidos, tecnologias de transporte e aplicações industriais.</p>
                        <a href="categoria-transporte-pneumatico.php" class="category-link">Explorar Artigos <i class="fas fa-arrow-right"></i></a>
                    </div>
                </div>
                
                <div class="category-card">
                    <img src="https://sierroengenharia.com.br/images/blog/projeto-industrial-category.jpg" alt="Projeto Industrial" class="category-image">
                    <div class="category-content">
                        <h3>Projeto Industrial</h3>
                        <p>Metodologias, boas práticas e estudos de caso sobre o desenvolvimento de projetos industriais eficientes.</p>
                        <a href="categoria-projeto-industrial.php" class="category-link">Explorar Artigos <i class="fas fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Latest Articles
        <section class="blog-latest">
            <h2 class="blog-section-title">Artigos Recentes</h2>
            <div class="latest-grid">
                <article class="article-card">
                    <img src="https://sierroengenharia.com.br/images/blog/spray-dryer-blog.png" alt="Spray Dryer na Indústria Moderna" class="article-image">
                    <div class="article-content">
                        <div class="article-meta">
                            <span><i class="fas fa-calendar"></i> 05/03/2025</span>
                            <span><i class="fas fa-folder"></i> Spray Dryer</span>
                        </div>
                        <h3>Spray Dryer na Indústria Moderna: Tecnologia, Aplicações e Inovações</h3>
                        <p>Descubra como o processo de secagem por atomização revoluciona a produção industrial, garantindo eficiência, qualidade e padronização.</p>
                        <a href="spray-dryer-industria-moderna.php" class="article-link">Leia mais</a>
                    </div>
                </article>
                
                <article class="article-card">
                    <img src="https://sierroengenharia.com.br/images/blog/transporte-pneumatico.jpg" alt="Transporte Pneumático" class="article-image">
                    <div class="article-content">
                        <div class="article-meta">
                            <span><i class="fas fa-calendar"></i> 28/02/2025</span>
                            <span><i class="fas fa-folder"></i> Transporte Pneumático</span>
                        </div>
                        <h3>Transporte Pneumático: Eficiência no Deslocamento de Materiais Sólidos</h3>
                        <p>Conheça os princípios, configurações e vantagens dos sistemas de transporte pneumático para otimizar sua operação industrial.</p>
                        <a href="transporte-pneumatico-eficiencia.php" class="article-link">Leia mais</a>
                    </div>
                </article>
                
                <article class="article-card">
                    <img src="https://sierroengenharia.com.br/images/blog/torre-secagem.jpg" alt="Torre de Secagem" class="article-image">
                    <div class="article-content">
                        <div class="article-meta">
                            <span><i class="fas fa-calendar"></i> 05/02/2025</span>
                            <span><i class="fas fa-folder"></i> Spray Dryer</span>
                        </div>
                        <h3>Torres de Secagem: Componentes e Otimização para Máxima Eficiência</h3>
                        <p>Um guia completo sobre torres de secagem, seus componentes principais e como otimizar seu funcionamento para resultados superiores.</p>
                        <a href="torres-secagem-componentes.php" class="article-link">Leia mais</a>
                    </div>
                </article>
                
                <article class="article-card">
                    <img src="https://sierroengenharia.com.br/images/blog/industria-4-0.jpg" alt="Indústria 4.0" class="article-image">
                    <div class="article-content">
                        <div class="article-meta">
                            <span><i class="fas fa-calendar"></i> 25/01/2025</span>
                            <span><i class="fas fa-folder"></i> Projeto Industrial</span>
                        </div>
                        <h3>Indústria 4.0: Adaptando sua Produção para o Futuro</h3>
                        <p>Entenda os conceitos fundamentais da Indústria 4.0 e descubra como preparar sua operação industrial para a transformação digital.</p>
                        <a href="industria-4-0-adaptacao.php" class="article-link">Leia mais</a>
                    </div>
                </article>
                
                <article class="article-card">
                    <img src="https://sierroengenharia.com.br/images/blog/sistemas-automacao.jpg" alt="Automação Industrial" class="article-image">
                    <div class="article-content">
                        <div class="article-meta">
                            <span><i class="fas fa-calendar"></i> 15/01/2025</span>
                            <span><i class="fas fa-folder"></i> Projeto Industrial</span>
                        </div>
                        <h3>Sistemas de Automação para Linhas de Produção Eficientes</h3>
                        <p>Explore as tecnologias de automação industrial que estão transformando as linhas de produção e garantindo maior produtividade.</p>
                        <a href="automacao-producao-eficiente.php" class="article-link">Leia mais</a>
                    </div>
                </article>
                
                <article class="article-card">
                    <img src="https://sierroengenharia.com.br/images/blog/case-sucesso.jpg" alt="Case de Sucesso" class="article-image">
                    <div class="article-content">
                        <div class="article-meta">
                            <span><i class="fas fa-calendar"></i> 08/01/2025</span>
                            <span><i class="fas fa-folder"></i> Casos de Sucesso</span>
                        </div>
                        <h3>Case de Sucesso: Modernização do Sistema Produtivo em Indústria Alimentícia</h3>
                        <p>Conheça os resultados impressionantes obtidos após a implementação de um sistema Spray Dryer integrado em uma indústria de laticínios.</p>
                        <a href="case-modernizacao-laticinios.php" class="article-link">Leia mais</a>
                    </div>
                </article>
            </div>
        </section>-->
        
        <!-- Newsletter Section 
        <section class="blog-newsletter">
            <h2>Inscreva-se em Nossa Newsletter</h2>
            <p>Receba mensalmente os melhores artigos, novidades do setor e dicas técnicas para otimizar seus processos industriais.</p>
            <form class="newsletter-form">
                <input type="email" placeholder="Seu e-mail" class="newsletter-input" required>
                <button type="submit" class="newsletter-btn">Inscrever-se</button>
            </form>
        </section>-->
        
        <!-- About Section -->
        <section class="blog-about">
            <div class="about-image">
                <img src="https://sierroengenharia.com.br/images/cone.jpg" alt="Sobre a Sierro Engenharia">
            </div>
            <div class="about-content">
                <h2>Sobre a Sierro Engenharia</h2>
                <p>A Sierro Engenharia traz experiência e tecnologia desde 1962, quando chegou ao Brasil por meio da Nestlé, com o propósito de oferecer projetos e soluções tecnológicas em equipamentos agroindustriais para o setor Sucroalcooleiro . Ao longo dos anos, a empresa expandiu seu alcance, beneficiando não apenas o setor de alimentos, mas também outros segmentos como o sucroalcooleiro, que passaram a contar com sua expertise em projetos e equipamentos de alta qualidade.</p>
                <a href="https://sierroengenharia.com.br/sobre.php" class="about-link">Conheça nossa história <i class="fas fa-arrow-right"></i></a>
            </div>
        </section>
    </main>
    
    <!-- Footer -->
    <footer class="blog-footer">
        <div class="blog-container">
            <div class="footer-content">
                <div class="footer-column footer-about">
                    <h4>Sobre a Sierro Engenharia</h4>
                    <p>A Sierro Engenharia é especializada em soluções industriais de alta performance, com foco em Spray Dryer, sistemas de transporte pneumático e projetos industriais personalizados.</p>
                    <div class="social-icons">
                        <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>
                
                <div class="footer-column footer-links">
                    <h4>Links Rápidos</h4>
                    <ul>
                        <li><a href="index.php">Página Inicial</a></li>
                        <li><a href="blog.php">Todos os Artigos</a></li>
                        <li><a href="spray-dryer.php">Spray Dryer</a></li>
                        <li><a href="categoria-transporte-pneumatico.php">Transporte Pneumático</a></li>
                        <li><a href="categoria-projeto-industrial.php">Projeto Industrial</a></li>
                        <li><a href="https://sierroengenharia.com.br/sobre.php">Sobre Nós</a></li>
                        <li><a href="https://sierroengenharia.com.br/contato.php">Contato</a></li>
                    </ul>
                </div>
                
                <div class="footer-column footer-contact">
                    <h4>Contato</h4>
                    <p><i class="fas fa-map-marker-alt"></i> São Paulo, SP - Brasil</p>
                    <p><i class="fas fa-phone"></i> (11) 9876-5432</p>
                    <p><i class="fas fa-envelope"></i> contato@sierroengenharia.com.br</p>
                </div>
                
                <div class="footer-column footer-newsletter">
                    <h4>Newsletter</h4>
                    <p>Assine nossa newsletter e receba as últimas atualizações sobre tecnologia industrial.</p>
                    <form class="newsletter-form">
                        <input type="email" placeholder="Seu e-mail" class="newsletter-input" required>
                        <button type="submit" class="newsletter-btn"><i class="fas fa-paper-plane"></i></button>
                    </form>
                </div>
            </div>
            
            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> Sierro Engenharia - Todos os direitos reservados</p>
                <p>Última atualização: <?php echo date('d/m/Y H:i:s'); ?> (Horário de Brasília)</p>
            </div>
        </div>
    </footer>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    <!-- Google Fonts - Poppins -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- JavaScript for Responsive Navigation -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Aqui você pode adicionar qualquer JavaScript necessário
            // para a funcionalidade da página
        });
    </script>
</body>
</html>