<?php
// translate.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Chave API do Google (mova isto para um arquivo de configuração em produção)
$apiKey = 'AIzaSyA7KDT9OJeqbKua69UjK6VU4tu1uTK8nBI';

// Recebe os dados do POST
$text = $_POST['text'] ?? '';
$targetLang = $_POST['target'] ?? 'en';
$sourceLang = $_POST['source'] ?? 'pt';

if (empty($text)) {
    echo json_encode(['error' => 'Texto vazio']);
    exit;
}

// URL da API do Google Translate
$url = "https://translation.googleapis.com/language/translate/v2?key=" . $apiKey;

// Dados para a requisição
$data = [
    'q' => $text,
    'target' => $targetLang,
    'source' => $sourceLang
];

// Configuração do cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

// Executa a requisição
$response = curl_exec($ch);

// Verifica erros
if (curl_errno($ch)) {
    echo json_encode(['error' => 'Erro na requisição: ' . curl_error($ch)]);
    exit;
}

curl_close($ch);

// Retorna a resposta
echo $response;