<?php 
$pageTitle = 'Secagem de Levedura - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Secagem de Levedura</h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">Projetos, Equipamentos e Torres</p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Soluções Completas</div>
                        <p>
                            A Sierro Engenharia desenvolve plantas completas para projetos e equipamentos voltados a levedura Lis (integra), levedura autolisada e parede celular. Cada projeto é personalizado para atender às necessidades e as especificações técnicas do cliente, seja para produção de insumos para a indústria alimentícia ou para outros setores; como a produção de leveduras utilizadas em fermentação de cana-de-açúcar e cerveja.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Tecnologia Avançada</div>
                        <p>
                            Utilizando as mais avançadas tecnologias de secagem, nossos equipamentos proporcionam uma desidratação uniforme da levedura, com um sistema projetado para garantir um processo eficiente e controlado, preservando a qualidade do produto final.
                        </p>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Nosso Compromisso</div>
                        <p>
                            Sempre com foco em eficiência operacional, qualidade e sustentabilidade.
                        </p>
                    </div>

                    <!-- Cards de Aplicações -->
                    <div class="applications-grid">
                        <div class="application-card" data-aos="fade-up">
                            <div class="app-icon">
                                <i class="fas fa-industry"></i>
                            </div>
                            <h3>Indústria Alimentícia</h3>
                            <ul class="app-features">
                                <li>Levedura Lis (íntegra)</li>
                                <li>Levedura Autolisada</li>
                                <li>Parede Celular</li>
                            </ul>
                        </div>

                        <div class="application-card" data-aos="fade-up" data-aos-delay="100">
                            <div class="app-icon">
                                <i class="fas fa-wine-bottle"></i>
                            </div>
                            <h3>Fermentação</h3>
                            <ul class="app-features">
                                <li>Cana-de-açúcar</li>
                                <li>Cerveja</li>
                                <li>Outros Processos</li>
                            </ul>
                        </div>
                    </div>

                    <!-- Seção CTA (Orçamento) -->
                    <div class="cta-section">
                        <div class="cta-content">
                            <h2>Precisa de um projeto personalizado?</h2>
                            <p>Entre em contato conosco para desenvolvermos a melhor solução para sua empresa</p>
                            <a href="contato.php" class="cta-button">
                                <span>Solicitar Orçamento</span>
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/levedura.png" alt="Secagem de Levedura Industrial">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-cog"></i>
                                    <span>Automação Total</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-tachometer-alt"></i>
                                    <span>Alta Performance</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>Qualidade Superior</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Indicadores de Performance -->
                    <div class="performance-stats">
                        <div class="stat-card">
                            <div class="stat-value">100%</div>
                            <div class="stat-label">Personalização</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-value">Máxima</div>
                            <div class="stat-label">Eficiência</div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-value">Garantida</div>
                            <div class="stat-label">Qualidade</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Layout Principal */
.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Texto e Conteúdo */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 40px;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

.text-block p {
    font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
    margin: 0;
}

/* Cards de Aplicações */
.applications-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 30px;
    margin: 40px 0;
}

.application-card {
    background: #f8f9fa;
    padding: 30px;
    border-radius: 15px;
    transition: all 0.3s ease;
}

.application-card:hover {
    transform: translateY(-10px);
    background: #fff2f0;
}

.app-icon {
    width: 60px;
    height: 60px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
}

.app-icon i {
    font-size: 24px;
    color: #e4451d;
}

.app-features {
    list-style: none;
    padding: 0;
    margin: 15px 0 0;
}

.app-features li {
    padding: 8px 0;
    color: #666;
    border-bottom: 1px solid rgba(0,0,0,0.1);
}

.app-features li:last-child {
    border-bottom: none;
}

/* Imagem e Overlay */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.image-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
    padding: 30px;
}

.specs-list {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.spec-item {
    color: white;
    text-align: center;
}

.spec-item i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #e4451d;
}

/* Performance Stats */
.performance-stats {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin-top: 30px;
}

.stat-card {
    background: white;
    padding: 20px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 10px 20px rgba(0,0,0,0.05);
}

.stat-value {
    font-size: 1.8rem;
    font-weight: 700;
    color: #e4451d;
    margin-bottom: 5px;
}

.stat-label {
    color: #666;
    font-size: 0.9rem;
}

/* CTA Section */
.cta-section {
    text-align: center;
    padding: 60px;
    background: linear-gradient(45deg, #00214e, #003175);
    border-radius: 20px;
    color: white;
    margin-top: 60px;
}

.cta-content h2 {
    font-size: 2.5rem;
    margin-bottom: 20px;
}

.cta-content p {
    font-size: 1.2rem;
    margin-bottom: 30px;
    opacity: 0.9;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: white;
    color: #00214e;
    transform: translateY(-2px);
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }

    .applications-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .cta-section {
        padding: 40px 20px;
    }

    .cta-content h2 {
        font-size: 2rem;
    }

    .performance-stats {
        grid-template-columns: 1fr;
    }

    .specs-list {
        grid-template-columns: 1fr;
        gap: 15px;
    }
}
</style>

<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>