<main class="article-content">
    <!-- Hero Section do Serviço -->
    <section class="service-hero">
        <div class="container">
            <div class="service-intro" data-aos="fade-up">
                <h1>Spray Dryer Industrial</h1>
                <div class="intro-separator">
                    <span class="line"></span>
                    <i class="fas fa-spray-can"></i>
                    <span class="line"></span>
                </div>
            </div>

            <div class="content-grid">
                <div class="text-content" data-aos="fade-right">
                    <p class="highlight-text">
                        Desenvolvemos soluções personalizadas em spray dryer, combinando tecnologia avançada com expertise em engenharia para atender às necessidades específicas da sua indústria.
                    </p>
                    
                    <a href="/contato" class="cta-button">
                        <span>Solicitar Orçamento</span>
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
                <div class="image-content" data-aos="fade-left">
                    <img src="images/spray-dryer-main.jpg" alt="Spray Dryer Industrial">
                </div>
            </div>
        </div>
    </section>

    <!-- Seção de Benefícios -->
    <section class="benefits-section">
        <div class="container">
            <div class="benefits-grid">
                <div class="benefit-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="benefit-icon">
                        <i class="fas fa-cogs"></i>
                    </div>
                    <h3>Automatização Completa</h3>
                    <p>Sistema totalmente automatizado garantindo processo contínuo e eficiente na produção.</p>
                </div>

                <div class="benefit-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="benefit-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>Alta Eficiência</h3>
                    <p>Tempos de residência curtos, ideal para produtos sensíveis à temperatura.</p>
                </div>

                <div class="benefit-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="benefit-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>Produtividade</h3>
                    <p>Maior rendimento e qualidade consistente no produto final.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Seção de Informações Detalhadas -->
    <section class="details-section">
        <div class="container">
            <div class="details-grid">
                <div class="details-content" data-aos="fade-right">
                    <h2>Tecnologia Avançada em Secagem</h2>
                    <p>Nossa tecnologia de spray dryer realiza a secagem de diversos produtos através do processo de atomização, convertendo eficientemente líquidos em pó.</p>
                    
                    <div class="applications-list">
                        <h3>Aplicações Principais:</h3>
                        <ul>
                            <li>
                                <i class="fas fa-check"></i>
                                <span>Leite e derivados lácteos</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i>
                                <span>Extratos de café e chá</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i>
                                <span>Produtos alimentícios</span>
                            </li>
                            <li>
                                <i class="fas fa-check"></i>
                                <span>Compostos químicos</span>
                            </li>
                        </ul>
                    </div>
                </div>
                
                <div class="details-image" data-aos="fade-left">
                    <img src="images/spray-dryer-detail.jpg" alt="Detalhes do Spray Dryer">
                </div>
            </div>
        </div>
    </section>

    <!-- Call to Action -->
    <section class="cta-section">
        <div class="container">
            <div class="cta-content" data-aos="fade-up">
                <h2>Pronto para otimizar seu processo industrial?</h2>
                <p>Entre em contato para uma consultoria especializada</p>
                <a href="/contato" class="cta-button">Solicitar Orçamento</a>
            </div>
        </div>
    </section>
</main>

<style>
/* Estilos Gerais */
.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

/* Hero Section */
.service-hero {
    padding: 100px 0 60px;
    background: linear-gradient(to bottom, #f8f9fa, white);
}

.service-intro {
    text-align: center;
    margin-bottom: 60px;
}

.service-intro h1 {
    color: #00214e;
    font-size: 3.5rem;
    margin-bottom: 20px;
    font-weight: 600;
}

.intro-separator {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 15px;
    margin: 20px 0;
}

.intro-separator .line {
    width: 50px;
    height: 2px;
    background: #e4451d;
}

.intro-separator i {
    color: #e4451d;
    font-size: 1.5rem;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 50px;
    align-items: center;
}

.text-content {
    padding-right: 50px;
}

.highlight-text {
    font-size: 1.3rem;
    line-height: 1.6;
    color: #444;
    margin-bottom: 30px;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: #00214e;
    transform: translateY(-2px);
}

.image-content img {
    width: 100%;
    border-radius: 20px;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

/* Benefits Section */
.benefits-section {
    padding: 80px 0;
    background: white;
}

.benefits-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 30px;
}

.benefit-card {
    text-align: center;
    padding: 40px 30px;
    background: #f8f9fa;
    border-radius: 20px;
    transition: all 0.3s ease;
}

.benefit-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.1);
}

.benefit-icon {
    width: 70px;
    height: 70px;
    margin: 0 auto 20px;
    background: #00214e;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.benefit-icon i {
    font-size: 1.8rem;
    color: white;
}

.benefit-card h3 {
    color: #00214e;
    margin-bottom: 15px;
    font-size: 1.3rem;
}

.benefit-card p {
    color: #666;
    line-height: 1.6;
}

/* Details Section */
.details-section {
    padding: 80px 0;
    background: #f8f9fa;
}

.details-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 50px;
    align-items: center;
}

.details-content h2 {
    color: #00214e;
    font-size: 2.5rem;
    margin-bottom: 20px;
}

.details-content p {
    color: #666;
    line-height: 1.6;
    margin-bottom: 30px;
}

.applications-list h3 {
    color: #00214e;
    margin-bottom: 20px;
}

.applications-list ul {
    list-style: none;
    padding: 0;
}

.applications-list li {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
}

.applications-list i {
    color: #e4451d;
}

.details-image img {
    width: 100%;
    border-radius: 20px;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

/* CTA Section */
.cta-section {
    padding: 100px 0;
    background: linear-gradient(45deg, #00214e, #003175);
    color: white;
    text-align: center;
}

.cta-content h2 {
    font-size: 2.5rem;
    margin-bottom: 20px;
}

.cta-content p {
    font-size: 1.2rem;
    margin-bottom: 30px;
    opacity: 0.9;
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid,
    .details-grid {
        grid-template-columns: 1fr;
    }

    .text-content {
        padding-right: 0;
        text-align: center;
    }

    .benefits-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .service-intro h1 {
        font-size: 2.5rem;
    }

    .benefits-grid {
        grid-template-columns: 1fr;
    }

    .details-content h2 {
        font-size: 2rem;
    }
}
</style>