<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require 'vendor/autoload.php';

header('Content-Type: application/json');

try {
    // Validação
    if (empty($_POST['name']) || empty($_POST['email']) || empty($_POST['phone']) || empty($_POST['message'])) {
        throw new Exception('Todos os campos são obrigatórios');
    }

    // Sanitização
    $name = filter_var($_POST['name'], FILTER_SANITIZE_STRING);
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $phone = filter_var($_POST['phone'], FILTER_SANITIZE_STRING);
    $message = filter_var($_POST['message'], FILTER_SANITIZE_STRING);

    // Configuração do PHPMailer
    $mail = new PHPMailer(true);

    // Configurações do Servidor
    $mail->isSMTP();
    $mail->Host = 'smtp.seudominio.com.br';  // Seu servidor SMTP
    $mail->SMTPAuth = true;
    $mail->Username = 'seu-email@seudominio.com.br';  // Seu email
    $mail->Password = 'sua-senha';  // Sua senha
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;  // ou ENCRYPTION_SMTPS
    $mail->Port = 587;  // ou 465 para SSL
    $mail->CharSet = 'UTF-8';

    // Destinatários
    $mail->setFrom($email, $name);
    $mail->addAddress('t.sierro@sierroengenharia.com.br', 'Sierro Engenharia');
    $mail->addAddress('flaviopiza@sierroengenharia.com.br', 'Flavio Piza');
    $mail->addReplyTo($email, $name);

    // Conteúdo
    $mail->isHTML(true);
    $mail->Subject = 'Novo contato do site - Sierro Engenharia';
    
    $emailBody = "
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: #00214e; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background: #f9f9f9; }
            .field { margin-bottom: 15px; }
            .label { font-weight: bold; color: #00214e; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h2>Novo Contato do Site</h2>
            </div>
            <div class='content'>
                <div class='field'>
                    <span class='label'>Nome:</span> $name
                </div>
                <div class='field'>
                    <span class='label'>E-mail:</span> $email
                </div>
                <div class='field'>
                    <span class='label'>Telefone:</span> $phone
                </div>
                <div class='field'>
                    <span class='label'>Mensagem:</span><br>
                    " . nl2br($message) . "
                </div>
            </div>
        </div>
    </body>
    </html>
    ";

    $mail->Body = $emailBody;
    $mail->AltBody = "Nome: $name\nE-mail: $email\nTelefone: $phone\nMensagem: $message";

    $mail->send();
    echo json_encode(['success' => true, 'message' => 'Mensagem enviada com sucesso']);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => "Erro ao enviar mensagem: {$e->getMessage()}"]);
}
?>