<?php 
$pageTitle = 'Projetos Industriais - Sierro Engenharia';
include 'header.php'; 
?>

<!-- Hero Section -->
<section class="hero-banner">
    <div class="container">
        <div class="hero-content">
            <h1 class="animate-up">Projetos Industriais</h1>
            <div class="hero-divider animate-up"></div>
            <p class="hero-subtitle animate-up">Soluções tecnológicas avançadas para sua indústria</p>
        </div>
    </div>
</section>

<!-- Conteúdo Principal -->
<main class="main-content">
    <div class="container">
        <!-- Grid Principal -->
        <div class="content-grid">
            <!-- Coluna de Texto -->
            <div class="text-column" data-aos="fade-right">
                <div class="text-content">
                    <div class="text-block">
                        <div class="section-tag">Soluções Completas</div>
                        <p>
                            A Sierro Engenharia oferece um portfólio completo de soluções tecnológicas para o desenvolvimento de projetos industriais. Nossos projetos e equipamentos são voltados para otimizar os processos de produção, trazendo eficiência, produtividade, qualidade e segurança às operações.
                        </p>
                    </div>

                    <!-- Sistemas Grid -->
                    <div class="systems-section">
                        <h3 class="systems-title">A Sierro desenvolve projetos de sistemas:</h3>
                        <div class="systems-grid">
                            <div class="system-card" data-aos="fade-up">
                                <div class="system-icon">
                                    <i class="fas fa-spray-can"></i>
                                </div>
                                <h4>Torre de secagem Spray Dryer completa</h4>
                            </div>

                            <div class="system-card" data-aos="fade-up" data-aos-delay="100">
                                <div class="system-icon">
                                    <i class="fas fa-sync-alt"></i>
                                </div>
                                <h4>Retrofit</h4>
                            </div>

                            <div class="system-card" data-aos="fade-up" data-aos-delay="200">
                                <div class="system-icon">
                                    <i class="fas fa-route"></i>
                                </div>
                                <h4>Linhas de transporte pneumático ou esteiras</h4>
                            </div>

                            <div class="system-card" data-aos="fade-up" data-aos-delay="300">
                                <div class="system-icon">
                                    <i class="fas fa-blender"></i>
                                </div>
                                <h4>Concentradores, homogeneizadores e pasteurizadores</h4>
                            </div>

                            <div class="system-card" data-aos="fade-up" data-aos-delay="400">
                                <div class="system-icon">
                                    <i class="fas fa-flask"></i>
                                </div>
                                <h4>Baterias de Extração completa com manifold</h4>
                            </div>

                            <div class="system-card" data-aos="fade-up" data-aos-delay="500">
                                <div class="system-icon">
                                    <i class="fas fa-tint"></i>
                                </div>
                                <h4>Controles de umidade</h4>
                            </div>

                            <div class="system-card system-card-wide" data-aos="fade-up" data-aos-delay="600">
                                <div class="system-icon">
                                    <i class="fas fa-toolbox"></i>
                                </div>
                                <h4>E uma vasta gama de utilidades industriais para a sua necessidade</h4>
                            </div>
                        </div>
                    </div>

                    <div class="text-block">
                        <div class="section-tag">Parcerias Estratégicas</div>
                        <p>
                            Atuamos também em conjunto com nossos parceiros para desenvolver soluções e equipamentos personalizados. Parceiros que agregam para a maior eficiência e alta qualidade de equipamentos, sempre buscando aumento de produtividade, respeitando sempre o meio ambiente na economia de recursos e emissões de particulados.
                        </p>
                    </div>

                    <!-- Benefícios -->
                    <div class="benefits-section">
                        <h3 class="benefits-title">Diferenciais dos nossos Projetos</h3>
                        <div class="benefits-grid">
                            <div class="benefit-item" data-aos="fade-up">
                                <div class="benefit-icon">
                                    <i class="fas fa-chart-line"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Eficiência</h4>
                                    <p>Processos otimizados para máximo desempenho operacional</p>
                                </div>
                            </div>
                            
                            <div class="benefit-item" data-aos="fade-up" data-aos-delay="100">
                                <div class="benefit-icon">
                                    <i class="fas fa-industry"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Produtividade</h4>
                                    <p>Aumento da capacidade produtiva e redução de tempos ociosos</p>
                                </div>
                            </div>
                            
                            <div class="benefit-item" data-aos="fade-up" data-aos-delay="200">
                                <div class="benefit-icon">
                                    <i class="fas fa-award"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Qualidade</h4>
                                    <p>Padrões rigorosos que garantem excelência em todos os projetos</p>
                                </div>
                            </div>
                            
                            <div class="benefit-item" data-aos="fade-up" data-aos-delay="300">
                                <div class="benefit-icon">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <div class="benefit-content">
                                    <h4>Segurança</h4>
                                    <p>Conformidade com normas e padrões de segurança nacionais e internacionais</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="cta-section">
                        <div class="cta-content">
                            <h2>Vamos desenvolver sua solução personalizada</h2>
                            <p>Entre em contato para discutirmos as necessidades específicas do seu projeto</p>
                            <a href="contato.php" class="cta-button">
                                <span>Solicitar Projeto</span>
                                <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Coluna da Imagem -->
            <div class="image-column" data-aos="fade-left">
                <div class="image-sticky">
                    <div class="main-image">
                        <img src="images/equipamentos.png" alt="Projetos Industriais Sierro">
                        <div class="image-overlay">
                            <div class="specs-list">
                                <div class="spec-item">
                                    <i class="fas fa-drafting-compass"></i>
                                    <span>Projetos Personalizados</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-puzzle-piece"></i>
                                    <span>Soluções Integradas</span>
                                </div>
                                <div class="spec-item">
                                    <i class="fas fa-cogs"></i>
                                    <span>Engenharia de Precisão</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Metodologia -->
                    <div class="methodology-box">
                        <h3 class="methodology-title">Nossa Metodologia</h3>
                        <div class="methodology-steps">
                            <div class="step-item">
                                <div class="step-number">01</div>
                                <div class="step-content">
                                    <h4>Análise</h4>
                                    <p>Diagnóstico completo das necessidades e processos</p>
                                </div>
                            </div>
                            
                            <div class="step-item">
                                <div class="step-number">02</div>
                                <div class="step-content">
                                    <h4>Projeto</h4>
                                    <p>Desenvolvimento técnico e dimensionamento</p>
                                </div>
                            </div>
                            
                            <div class="step-item">
                                <div class="step-number">03</div>
                                <div class="step-content">
                                    <h4>Execução</h4>
                                    <p>Fabricação e implementação com acompanhamento</p>
                                </div>
                            </div>
                            
                            <div class="step-item">
                                <div class="step-number">04</div>
                                <div class="step-content">
                                    <h4>Suporte</h4>
                                    <p>Treinamento e assistência técnica contínua</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Indicadores de Expertise -->
                    <div class="expertise-indicators">
                        <div class="expertise-card">
                            <div class="expertise-value">25+</div>
                            <div class="expertise-label">Anos de Experiência</div>
                        </div>
                        <div class="expertise-card">
                            <div class="expertise-value">300+</div>
                            <div class="expertise-label">Projetos Realizados</div>
                        </div>
                        <div class="expertise-card">
                            <div class="expertise-value">100%</div>
                            <div class="expertise-label">Satisfação</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
/* Layout Principal */
.container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 20px;
}

.main-content {
    padding: 80px 0;
    background: #f8f9fa;
}

.content-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 60px;
    align-items: start;
}

/* Hero Banner */
.hero-banner {
    background: linear-gradient(45deg, #00214e, #003175);
    padding: 100px 0;
    color: white;
    position: relative;
    overflow: hidden;
}

.hero-banner::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 50%;
    height: 100%;
    background: url('assets/images/pattern.png') repeat;
    opacity: 0.1;
}

.hero-content {
    text-align: center;
    position: relative;
    z-index: 2;
}

.hero-content h1 {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.hero-divider {
    width: 100px;
    height: 4px;
    background: #e4451d;
    margin: 0 auto 20px;
}

.hero-subtitle {
    font-size: 1.5rem;
    opacity: 0.9;
}

/* Texto e Conteúdo */
.text-column {
    padding-right: 40px;
}

.text-content {
    background: white;
    padding: 40px;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.text-block {
    margin-bottom: 40px;
}

.section-tag {
    display: inline-block;
    padding: 8px 16px;
    background: #fff2f0;
    color: #e4451d;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 500;
    margin-bottom: 15px;
}

.text-block p {
    font-size: 1.2rem;
    line-height: 1.8;
    color: #444;
    text-align: justify;
    text-justify: inter-word;
    margin: 0;
}

/* Sistemas Grid */
.systems-section {
    margin: 50px 0;
}

.systems-title {
    margin-bottom: 30px;
    color: #00214e;
    font-weight: 600;
}

.systems-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
}

.system-card {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 20px;
    background: #f8f9fa;
    border-radius: 10px;
    transition: all 0.3s ease;
}

.system-card-wide {
    grid-column: span 2;
}

.system-card:hover {
    transform: translateY(-5px);
    background: #fff2f0;
}

.system-icon {
    width: 50px;
    height: 50px;
    background: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.system-icon i {
    font-size: 20px;
    color: #e4451d;
}

.system-card h4 {
    margin: 0;
    font-size: 1rem;
    color: #00214e;
}

/* Benefícios */
.benefits-section {
    margin-top: 50px;
    padding: 30px;
    background: #f8f9fa;
    border-radius: 15px;
}

.benefits-title {
    text-align: center;
    margin-bottom: 30px;
    color: #00214e;
    font-weight: 600;
}

.benefits-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
}

.benefit-item {
    display: flex;
    align-items: flex-start;
    background: white;
    padding: 20px;
    border-radius: 10px;
    gap: 15px;
    transition: all 0.3s ease;
}

.benefit-item:hover {
    transform: translateX(10px);
    background: #fff2f0;
}

.benefit-icon {
    width: 45px;
    height: 45px;
    background: #f8f9fa;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.benefit-icon i {
    font-size: 18px;
    color: #e4451d;
}

.benefit-content h4 {
    margin: 0 0 5px;
    color: #00214e;
    font-size: 1.1rem;
}

.benefit-content p {
    margin: 0;
    font-size: 0.9rem;
    color: #666;
}

/* Imagem e Overlay */
.image-sticky {
    position: sticky;
    top: 20px;
}

.main-image {
    position: relative;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
}

.main-image img {
    width: 100%;
    height: auto;
    display: block;
    transition: transform 0.3s ease;
}

.main-image:hover img {
    transform: scale(1.05);
}

.image-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
    padding: 30px;
}

.specs-list {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
}

.spec-item {
    color: white;
    text-align: center;
}

.spec-item i {
    font-size: 24px;
    margin-bottom: 10px;
    color: #e4451d;
}

/* Metodologia */
.methodology-box {
    background: white;
    border-radius: 15px;
    padding: 30px;
    margin-top: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05);
}

.methodology-title {
    color: #00214e;
    font-weight: 600;
    text-align: center;
    margin-bottom: 20px;
}

.methodology-steps {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.step-item {
    display: flex;
    align-items: flex-start;
    gap: 15px;
    padding-bottom: 20px;
    border-bottom: 1px dashed rgba(0,0,0,0.1);
}

.step-item:last-child {
    border-bottom: none;
    padding-bottom: 0;
}

.step-number {
    width: 40px;
    height: 40px;
    background: #f8f9fa;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    color: #e4451d;
    font-size: 1.2rem;
    flex-shrink: 0;
}

.step-content h4 {
    margin: 0 0 5px;
    color: #00214e;
}

.step-content p {
    margin: 0;
    font-size: 0.9rem;
    color: #666;
}

/* Expertise Indicators */
.expertise-indicators {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin-top: 30px;
}

.expertise-card {
    background: white;
    padding: 20px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 10px 20px rgba(0,0,0,0.05);
}

.expertise-value {
    font-size: 1.8rem;
    font-weight: 700;
    color: #e4451d;
    margin-bottom: 5px;
}

.expertise-label {
    color: #666;
    font-size: 0.9rem;
}

/* CTA Section */
.cta-section {
    text-align: center;
    padding: 60px;
    background: linear-gradient(45deg, #00214e, #003175);
    border-radius: 20px;
    color: white;
    margin-top: 60px;
}

.cta-content h2 {
    font-size: 2.5rem;
    margin-bottom: 20px;
}

.cta-content p {
    font-size: 1.2rem;
    margin-bottom: 30px;
    opacity: 0.9;
}

.cta-button {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 15px 30px;
    background: #e4451d;
    color: white;
    text-decoration: none;
    border-radius: 30px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.cta-button:hover {
    background: white;
    color: #00214e;
    transform: translateY(-2px);
}

/* Responsividade */
@media (max-width: 992px) {
    .content-grid {
        grid-template-columns: 1fr;
    }

    .text-column {
        padding-right: 0;
    }

    .image-sticky {
        position: relative;
        top: 0;
        margin-top: 40px;
    }

    .systems-grid {
        grid-template-columns: 1fr;
    }

    .system-card-wide {
        grid-column: span 1;
    }
}

@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }

    .hero-subtitle {
        font-size: 1.2rem;
    }

    .text-content {
        padding: 20px;
    }

    .cta-section {
        padding: 40px 20px;
    }

    .cta-content h2 {
        font-size: 2rem;
    }

    .benefits-grid {
        grid-template-columns: 1fr;
    }

    .specs-list {
        grid-template-columns: 1fr;
        gap: 15px;
    }

    .expertise-indicators {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
    AOS.init({
        duration: 800,
        once: true
    });
</script>

<?php include 'footer.php'; ?>
    