<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Contato | Sierro Engenharia</title>
    <meta name="description" content="Entre em contato com a Sierro Engenharia. Especialistas em Spray Dryer e soluções industriais.">
    
    <!-- CSS do Contato -->
    <style>
    .contact-section {
        padding: 80px 0;
        background: #f8f9fa;
    }

    .contact-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 50px;
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
    }

    .contact-info {
        padding: 30px;
        background: white;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }

    .contact-header {
        margin-bottom: 30px;
    }

    .contact-header h1 {
        color: #00214e;
        font-size: 2.5rem;
        margin-bottom: 15px;
    }

    .contact-header p {
        color: #666;
        font-size: 1.1rem;
        line-height: 1.6;
    }

    .contact-methods {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .contact-item {
        display: flex;
        align-items: center;
        gap: 15px;
        padding: 15px;
        background: #f8f9fa;
        border-radius: 10px;
        transition: all 0.3s ease;
    }

    .contact-item:hover {
        background: #00214e;
        color: white;
        transform: translateX(10px);
    }

    .contact-item i {
        font-size: 24px;
        color: #e4451d;
    }

    .contact-item:hover i {
        color: white;
    }

    .contact-item-content h3 {
        font-size: 1.1rem;
        margin-bottom: 5px;
    }

    .contact-item-content a {
        color: inherit;
        text-decoration: none;
    }

    .contact-form {
        padding: 30px;
        background: white;
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: #00214e;
        font-weight: 500;
    }

    .form-control {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #eee;
        border-radius: 8px;
        font-size: 1rem;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: #00214e;
        outline: none;
        box-shadow: 0 0 0 3px rgba(0,33,78,0.1);
    }

    textarea.form-control {
        min-height: 150px;
        resize: vertical;
    }

    .submit-btn {
        background: #e4451d;
        color: white;
        border: none;
        padding: 15px 30px;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
        width: 100%;
    }

    .submit-btn:hover {
        background: #00214e;
        transform: translateY(-3px);
    }

    .error-message {
        color: #e4451d;
        font-size: 0.9rem;
        margin-top: 5px;
        display: none;
    }

    .success-message {
        background: #4CAF50;
        color: white;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
        display: none;
    }
    
    .email-options {
        margin-top: 20px;
        text-align: center;
    }
    
    .email-option {
        display: inline-block;
        margin: 0 10px;
        padding: 10px 15px;
        background: #f0f0f0;
        border-radius: 5px;
        text-decoration: none;
        color: #333;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .email-option:hover {
        background: #00214e;
        color: white;
    }

    @media (max-width: 992px) {
        .contact-grid {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .contact-section {
            padding: 60px 0;
        }

        .contact-header h1 {
            font-size: 2rem;
        }
    }
    </style>
</head>
<body>
    <?php include 'header.php'; ?>

    <main>
        <section class="contact-section">
            <div class="contact-grid">
                <!-- Informações de Contato -->
                <div class="contact-info">
                    <div class="contact-header">
                        <h1>Fale Conosco</h1>
                        <p>Entre em contato conosco para soluções em engenharia industrial, spray dryer e muito mais.</p>
                    </div>

                    <div class="contact-methods">
                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="contact-item-content">
                                <h3>E-mail Engenharia</h3>
                                <a href="mailto:t.sierro@sierroengenharia.com.br">t.sierro@sierroengenharia.com.br</a>
                            </div>
                        </div>

                        <div class="contact-item">
                            <i class="fas fa-envelope"></i>
                            <div class="contact-item-content">
                                <h3>E-mail Comercial/Operacional</h3>
                                <a href="mailto:flaviopiza@sierroengenharia.com.br">flaviopiza@sierroengenharia.com.br</a>
                            </div>
                        </div>

                        <div class="contact-item">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="contact-item-content">
                                <h3>Endereço</h3>
                                <p>São Paulo, SP - Brasil</p>
                            </div>
                        </div>

                        <div class="contact-item">
                            <i class="fas fa-clock"></i>
                            <div class="contact-item-content">
                                <h3>Horário de Atendimento</h3>
                                <p>Segunda a Sexta: 8h às 18h</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Formulário de Contato -->
                <div class="contact-form">
                    <div id="success-message" class="success-message">
                        Formulário preenchido com sucesso! Escolha para qual e-mail deseja enviar:
                        <div class="email-options">
                            <a href="#" class="email-option" id="email-operational">E-mail Operacional</a>
                            <a href="#" class="email-option" id="email-commercial">E-mail Comercial</a>
                        </div>
                    </div>

                    <form id="contactForm">
                        <div class="form-group">
                            <label for="name">Nome</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                            <div class="error-message" id="name-error"></div>
                        </div>

                        <div class="form-group">
                            <label for="phone">Telefone</label>
                            <input type="tel" class="form-control" id="phone" name="phone" required>
                            <div class="error-message" id="phone-error"></div>
                        </div>

                        <div class="form-group">
                            <label for="email">E-mail</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                            <div class="error-message" id="email-error"></div>
                        </div>

                        <div class="form-group">
                            <label for="message">Mensagem</label>
                            <textarea class="form-control" id="message" name="message" required></textarea>
                            <div class="error-message" id="message-error"></div>
                        </div>

                        <button type="submit" class="submit-btn">Enviar Mensagem</button>
                    </form>
                </div>
            </div>
        </section>
    </main>

    <?php include 'footer.php'; ?>

    <!-- Script de Validação -->
    <script>
    document.getElementById('contactForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Reset error messages
        document.querySelectorAll('.error-message').forEach(error => error.style.display = 'none');
        
        // Validate fields
        let isValid = true;
        const name = document.getElementById('name');
        const phone = document.getElementById('phone');
        const email = document.getElementById('email');
        const message = document.getElementById('message');

        // Name validation
        if (name.value.length < 3) {
            document.getElementById('name-error').textContent = 'Nome deve ter pelo menos 3 caracteres';
            document.getElementById('name-error').style.display = 'block';
            isValid = false;
        }

        // Phone validation
        if (!/^\d{10,11}$/.test(phone.value.replace(/\D/g, ''))) {
            document.getElementById('phone-error').textContent = 'Telefone inválido';
            document.getElementById('phone-error').style.display = 'block';
            isValid = false;
        }

        // Email validation
        if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email.value)) {
            document.getElementById('email-error').textContent = 'E-mail inválido';
            document.getElementById('email-error').style.display = 'block';
            isValid = false;
        }

        // Message validation
        if (message.value.length < 10) {
            document.getElementById('message-error').textContent = 'Mensagem deve ter pelo menos 10 caracteres';
            document.getElementById('message-error').style.display = 'block';
            isValid = false;
        }

        if (isValid) {
            // Mostrar opções de e-mail
            document.getElementById('success-message').style.display = 'block';
            
            // Preparar os dados para o e-mail
            const formData = {
                name: name.value,
                phone: phone.value,
                email: email.value,
                message: message.value
            };
            
            // Configurar os botões de e-mail
            document.getElementById('email-operational').addEventListener('click', function(evt) {
                evt.preventDefault();
                sendEmail('t.sierro@sierroengenharia.com.br', formData);
            });
            
            document.getElementById('email-commercial').addEventListener('click', function(evt) {
                evt.preventDefault();
                sendEmail('flaviopiza@sierroengenharia.com.br', formData);
            });
        }
    });
    
    // Função para enviar e-mail via mailto
    function sendEmail(to, data) {
        const subject = encodeURIComponent('Contato via Site - Sierro Engenharia');
        const body = encodeURIComponent(
            `Nome: ${data.name}\n` +
            `Telefone: ${data.phone}\n` +
            `E-mail: ${data.email}\n\n` +
            `Mensagem:\n${data.message}\n\n` +
            `Enviado em: ${new Date().toLocaleString('pt-BR', {timeZone: 'America/Sao_Paulo'})}`
        );
        
        // Abrir cliente de e-mail do usuário
        window.location.href = `mailto:${to}?subject=${subject}&body=${body}`;
        
        // Opcional: resetar o formulário
        document.getElementById('contactForm').reset();
    }

    // Phone mask
    document.getElementById('phone').addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 11) value = value.slice(0, 11);
        
        // Aplicar máscara de telefone com DDD
        if (value.length <= 2) {
            e.target.value = value;
        } else if (value.length <= 6) {
            e.target.value = `(${value.slice(0, 2)}) ${value.slice(2)}`;
        } else if (value.length <= 10) {
            e.target.value = `(${value.slice(0, 2)}) ${value.slice(2, 6)}-${value.slice(6)}`;
        } else {
            e.target.value = `(${value.slice(0, 2)}) ${value.slice(2, 7)}-${value.slice(7)}`;
        }
    });
    </script>
</body>
</html>